/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMAnimation;
import filenet.sim.animationdp.IVWSIMAnimationInfo;
import filenet.sim.animationdp.IVWSIMEvent;
import filenet.sim.animationdp.IVWSIMStatistics;
import filenet.sim.animationdp.impl2.AnimationInfo;
import filenet.sim.animationdp.impl2.Statistics;
import filenet.vw.api.VWException;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class AnimationManager
implements IVWSIMEvent,
IVWSIMAnimation {
    private boolean finished = false;
    private int m_status = 0;
    private String m_statusMessage = "RUNNING::::";
    private Hashtable m_animationInfo = new Hashtable();
    private Statistics m_stats = new Statistics();
    private long m_tDump = -1L;

    public IVWSIMAnimationInfo[] getAnimationInfo() {
        return this.m_animationInfo.values().toArray(new IVWSIMAnimationInfo[0]);
    }

    public IVWSIMAnimation getAnimation() throws VWException {
        return this;
    }

    public IVWSIMStatistics getStatistics() throws VWException {
        return this.m_stats;
    }

    public boolean finished() {
        return this.finished;
    }

    public Date getTimeStamp() {
        return new Date(this.m_tDump);
    }

    public String getStatusMessage() {
        return this.m_statusMessage;
    }

    public int getStatus() {
        return this.m_status;
    }

    public AnimationManager() {
    }

    protected AnimationManager(boolean finished, int statusInt, String statusMsg) {
        this.finished = finished;
        this.m_status = statusInt;
        this.m_statusMessage = statusMsg;
    }

    protected static AnimationManager[] fromBytes(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        DataInputStream objIs = new DataInputStream(byteStream);
        ArrayList<AnimationManager> a = new ArrayList<AnimationManager>(100);
        while (objIs.available() > 0) {
            AnimationManager mgr = new AnimationManager();
            mgr.readFromStream(objIs);
            a.add(mgr);
        }
        objIs.close();
        return a.toArray(new AnimationManager[0]);
    }

    protected void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.finished = in.readBoolean();
        this.m_status = in.readInt();
        this.m_statusMessage = in.readUTF();
        this.m_tDump = in.readLong();
        this.m_animationInfo.clear();
        int count = in.readInt();
        while (count-- > 0) {
            AnimationInfo item = new AnimationInfo();
            item.readFromStream(in);
            this.m_animationInfo.put(Integer.toString(item.getWorkClassID()), item);
        }
        boolean hasStats = in.readBoolean();
        if (hasStats) {
            this.m_stats.readFromStream(in);
        }
    }

    protected void merge(AnimationManager that) {
        this.finished = that.finished;
        this.m_status = that.m_status;
        this.m_statusMessage = that.m_statusMessage;
        this.m_tDump = that.m_tDump;
        this.m_animationInfo = that.m_animationInfo;
        this.m_stats.merge(that.m_stats);
    }

    private int getAnimationInfoStringSize() {
        int size = 0;
        Enumeration e = this.m_animationInfo.elements();
        while (e.hasMoreElements()) {
            size += ((AnimationInfo)e.nextElement()).getToStringSize();
        }
        return size;
    }

    public String toString() {
        int size = 32 + this.m_stats.getToStringSize() + this.getAnimationInfoStringSize();
        StringBuffer buf = new StringBuffer(size);
        if (this.m_tDump != -1L) {
            buf.append(new Date(this.m_tDump)).append("\n");
        }
        buf.append(this.m_status).append(" ").append(this.m_statusMessage).append(this.finished ? " " : " NOT ").append("FINISHED \n");
        Enumeration e = this.m_animationInfo.elements();
        while (e.hasMoreElements()) {
            ((AnimationInfo)e.nextElement()).toString(buf);
        }
        buf.append("\n");
        this.m_stats.toString(buf);
        return buf.toString();
    }

    protected void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("A_MGR.1.0");
        out.writeBoolean(this.finished);
        out.writeInt(this.m_status);
        out.writeUTF(this.m_statusMessage);
        out.writeLong(this.m_tDump);
        int count = this.m_animationInfo.size();
        out.writeInt(count);
        if (count > 0) {
            Enumeration e = this.m_animationInfo.elements();
            while (e.hasMoreElements()) {
                ((AnimationInfo)e.nextElement()).writeToStream(out);
            }
        }
        out.writeBoolean(true);
        this.m_stats.writeToStream(out);
    }
}

